<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// --- MySQL DB Configuration ---
$DB_DSN  = 'mysql:host=localhost;dbname=afsregtaxrolls_tar_multi;charset=utf8mb4';
$DB_USER = 'afsregtaxrolls_tar_multi';
$DB_PASS = 'tar_multi';






try {
    $pdo = new PDO($DB_DSN, $DB_USER, $DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
    
  // ✅ Step 1: Fetch start line from DB
    $stmt = $pdo->query("SELECT page FROM page WHERE id = 1 LIMIT 1");
    $row = $stmt->fetch();

    if (!$row) {
        throw new Exception("Page row not found for ID = 1.");
    }

    echo $startLine = (int)$row['page'];
    $recordsToRead = 21150;  
    
    // ✅ Step 3: After processing, update the page for next batch
    $newStartLine = $startLine + $recordsToRead;
    $updateStmt = $pdo->prepare("UPDATE page  SET page = :newPage WHERE id = 1");
    $updateStmt->execute([':newPage' => $newStartLine]);

    echo "✅ Processed lines $startLine to " . ($newStartLine - 1) . ". Next startLine set to $newStartLine.\n";



// File and reading configuration
$filePath = __DIR__ . '/files/PropertyDataFlat_2025.txt';
// $startLine = 1823987;     // what line number to begin
// $recordsToRead = 10;   // how many records to read

if (!file_exists($filePath)) {
    die("File not found: $filePath");
}

$handle = fopen($filePath, 'r');
if (!$handle) {
    die("Unable to open the file.");
}

// Helper to safely substring & trim
function getField($string, $start, $length) {
    // Spec uses 1‑based positions; substr is 0‑based
    return trim(substr($string, $start - 1, $length));
}

// Map for site_class from property_class codes
$siteClassMap = [
    'A'  => ['site_class_full' => 'Residential', 'site_class_type' => 'Single Family'],
    'AC' => ['site_class_full' => 'Residential', 'site_class_type' => 'Single Family Interim Use'],
    'A1' => ['site_class_full' => 'Residential', 'site_class_type' => 'Single Family'],
    'A2' => ['site_class_full' => 'Residential', 'site_class_type' => 'Mobile Home'],
    'A3' => ['site_class_full' => 'Residential', 'site_class_type' => 'Condominium'],
    'A4' => ['site_class_full' => 'Residential', 'site_class_type' => 'Townhouse'],
    'A5' => ['site_class_full' => 'Residential', 'site_class_type' => 'Planned Unit'],
    'B'  => ['site_class_full' => 'Residential', 'site_class_type' => 'Multi‑Family'],
    'BC' => ['site_class_full' => 'Residential', 'site_class_type' => 'Multi‑Family Commercial'],
    'B2' => ['site_class_full' => 'Residential', 'site_class_type' => 'Duplex'],
    'B3' => ['site_class_full' => 'Residential', 'site_class_type' => 'Triplex'],
    'B4' => ['site_class_full' => 'Residential', 'site_class_type' => 'Quadplex'],
    'C1' => ['site_class_full' => 'Land', 'site_class_type' => 'Vacant Residential Land'],
    'C1C'=> ['site_class_full' => 'Land', 'site_class_type' => 'Vacant Commercial Land'],
    'C2C'=> ['site_class_full' => 'Land', 'site_class_type' => 'Commercial Land w/ Improvements'],
    'D1' => ['site_class_full' => 'Agricultural', 'site_class_type' => 'Qualified Open Space Land'],
    'D2' => ['site_class_full' => 'Agricultural', 'site_class_type' => 'Farm/Ranch Improvements on Ag Land'],
    'E'  => ['site_class_full' => 'Residential', 'site_class_type' => 'Rural Land'],
    'EC' => ['site_class_full' => 'Commercial', 'site_class_type' => 'Rural Land Commercial'],
    'F1' => ['site_class_full' => 'Commercial', 'site_class_type' => 'General Commercial'],
    // ... include the rest of your mapping
];

// Owner type detection by keywords in owner name
function getOwnerType(string $ownerName): string {
    $companyKeywords = ['LLC', 'INC', 'CORP', 'TRUST', 'BANK', 'CO', 'COMPANY', 'ASSOCIATES', 'HOLDINGS', 'LP', 'LLP', 'CORPORATION', 'LTD'];
    $ownerNameUpper = strtoupper($ownerName);
    foreach ($companyKeywords as $keyword) {
        if (strpos($ownerNameUpper, $keyword) !== false) {
            return 'Company';
        }
    }
    return 'Person';
}

// Skip lines to start
$currentLine = 0;
while (!feof($handle) && $currentLine < ($startLine - 1)) {
    fgets($handle);
    $currentLine++;
}

$results = [];
$count = 0;

while (!feof($handle) && $count < $recordsToRead) {
    $line = fgets($handle);
    if ($line === false) break;
    if (trim($line) === '') continue;

    // Extract fields
    $account_type         = getField($line, 1, 1);              // R, C, P, M
    $appraisal_year       = getField($line, 2, 4);
    $account_num_full     = getField($line, 6, 8);
    $record_type          = getField($line, 14, 4);             // e.g. "AAAA"
    $seq_num              = getField($line, 18, 3);
    $PIDN                 = getField($line, 21, 20);
    $owner_name           = getField($line, 41, 30);
    $owner_address        = getField($line, 71, 30);
    $owner_citystate      = getField($line, 101, 30);
    $owner_zip            = getField($line, 131, 5);
    $owner_zip4           = getField($line, 136, 4);
    $owner_crrt           = getField($line, 140, 5);
    $situs_address        = getField($line, 145, 30);
    $property_class       = getField($line, 175, 4);
    $tad_map              = getField($line, 179, 9);
    $mapsco               = getField($line, 188, 4);
    $exemption_code       = getField($line, 192, 4);
    $state_use_code       = getField($line, 196, 2);
    $legal_line           = getField($line, 198, 128);
    $notice_date          = getField($line, 326, 10);
    $county_code          = getField($line, 336, 3);
    $city_code            = getField($line, 339, 3);
    $school_code          = getField($line, 342, 3);
    $num_special_dist     = getField($line, 345, 1);
    $spec1_code           = getField($line, 346, 3);
    $spec2_code           = getField($line, 349, 3);
    $spec3_code           = getField($line, 352, 3);
    $spec4_code           = getField($line, 355, 3);
    $spec5_code           = getField($line, 358, 3);
    $deed_date            = getField($line, 361, 10);
    $deed_book            = getField($line, 371, 7);
    $deed_page            = getField($line, 378, 7);
    $land_value           = getField($line, 385, 12);
    $improvement_value    = getField($line, 397, 12);
    $total_value          = getField($line, 409, 12);
    $garage_capacity      = getField($line, 421, 2);
    $num_bedrooms         = getField($line, 423, 2);
    $num_bathrooms        = getField($line, 425, 2);
    $year_built           = getField($line, 427, 4);
    $living_area          = getField($line, 431, 7);
    $swimming_pool_ind    = getField($line, 438, 1);
    $arb_indicator        = getField($line, 439, 1);
    $ag_code              = getField($line, 440, 1);
    $land_acres           = getField($line, 441, 9);
    $land_sqft            = getField($line, 450, 9);
    $ag_acres             = getField($line, 459, 9);
    $ag_value             = getField($line, 468, 9);
    $central_heat_ind     = getField($line, 477, 1);
    $central_air_ind      = getField($line, 478, 1);
    $structure_count      = getField($line, 479, 2);
    $from_accts           = getField($line, 481, 26);
    $appraisal_date       = getField($line, 507, 10);
    $appraised_value      = getField($line, 517, 12);
    $gis_link             = getField($line, 529, 25);
    $instrument_no        = getField($line, 554, 10);
    $overlap_flag         = getField($line, 564, 1);

    // --- Added zoning_code at pos 565 length 10 (adjust if needed) ---
    $zoning_code          = getField($line, 565, 10);

    // Derived / normalized variables
    $account_num = ltrim($account_num_full, '0');
    if ($account_num === '') {
        $account_num = '0';
    }

    // Site class mapping from property_class
    $site_info = $siteClassMap[trim($property_class)] ?? ['site_class_full' => 'Unknown', 'site_class_type' => 'Unknown'];

    // Vacancy detection logic
    $is_vacant = false;

    // Rule 1: property_class indicates a vacant land class
    $vacant_classes = ['C1', 'C1C'];
    if (in_array(trim($property_class), $vacant_classes, true)) {
        $is_vacant = true;
    }

    // Rule 2: no improvements and no living area
    if (!$is_vacant) {
        if ((float)$improvement_value == 0.0 && (int)$living_area == 0) {
            $is_vacant = true;
        }
    }

    // Rule 3: year built missing or zero + no improvements
    if (!$is_vacant) {
        if (($year_built === "" || (int)$year_built === 0) && (float)$improvement_value == 0.0) {
            $is_vacant = true;
        }
    }

    // Determine owner type
    $owner_type = getOwnerType($owner_name);

    // Build your final variables (for DB insert or whatever you need)
    $record = [
        'account_type'        => $account_type,
        'appraisal_year'      => $appraisal_year,
        'account_num'         => $account_num,
        'PIDN'                => $PIDN,
        'owner_name'          => $owner_name,
        'owner_type'          => $owner_type,
        'owner_address'       => $owner_address,
        'owner_citystate'     => $owner_citystate,
        'owner_zip'           => $owner_zip,
        'owner_zip4'          => $owner_zip4,
        'situs_address'       => $situs_address,
        'property_class'      => trim($property_class),
        'site_class_full'     => $site_info['site_class_full'],
        'site_class_type'     => $site_info['site_class_type'],
        'is_vacant'           => $is_vacant ? "Vacant" : 0,
        'land_value'          => (float)$land_value,
        'improvement_value'   => (float)$improvement_value,
        'total_value'         => (float)$total_value,
        'year_built'          => (int)$year_built,
        'living_area'         => (int)$living_area,
        'num_bedrooms'        => (int)$num_bedrooms,
        'num_bathrooms'       => (int)$num_bathrooms,
        'zoning_code'         => $zoning_code,
        'inserted_at'         => date('Y-m-d H:i:s'),
        'updated_at'          => date('Y-m-d H:i:s'),
    ];

    $results[] = $record;
    $count++;
}// --- MySQLi DB Configuration ---
$mysqli = new mysqli("localhost", "afsregtaxrolls_tar_multi", "tar_multi", "afsregtaxrolls_tar_multi");

if ($mysqli->connect_errno) {
    die("❌ Failed to connect to MySQL: " . $mysqli->connect_error);
}

foreach ($results as $record) {
    // Escape each value
    $account          = $mysqli->real_escape_string($record['account_num']);
    $owner_name       = $mysqli->real_escape_string($record['owner_name']);
    $owner_type       = $mysqli->real_escape_string($record['owner_type']);
    $address          = $mysqli->real_escape_string($record['owner_address']);
    $city             = $mysqli->real_escape_string($record['owner_citystate']);
    $zip              = $mysqli->real_escape_string($record['owner_zip']);
    $property_class   = $mysqli->real_escape_string($record['property_class']);
    $site_name        = $property_class; // Duplicate per mapping
    $site_class_full  = $mysqli->real_escape_string($record['site_class_full']);
    $site_class_type  = $mysqli->real_escape_string($record['site_class_type']);
    $is_vacant        = (int)$record['is_vacant'];
    $year_built       = (int)$record['year_built'];
    $living_area      = (int)$record['living_area'];
    $impr_value       = (float)$record['improvement_value'];
    $total_value      = (float)$record['total_value'];
    $zoning_code      = $mysqli->real_escape_string($record['zoning_code']);
    $land_acres       = isset($record['land_acres']) ? (float)$record['land_acres'] : 0;
    $inserted_at      = $mysqli->real_escape_string($record['inserted_at']);
    $updated_at       = $mysqli->real_escape_string($record['updated_at']);

    // Insert Query
    $sql = "
        INSERT INTO mf_candidates (
            account, owner_name, owner_type, address, city, zip,
            property_class, site_name, site_class_full, site_class_type,
            classification, year_built, living_area, impr_value,
            total_value, zoning_code, land_acres, inserted_at, updated_at
        ) VALUES (
            '$account', '$owner_name', '$owner_type', '$address', '$city', '$zip',
            '$property_class', '$site_name', '$site_class_full', '$site_class_type',
            $is_vacant, $year_built, $living_area, $impr_value,
            $total_value, '$zoning_code', $land_acres, '$inserted_at', '$updated_at'
        )
    ";
    
    // echo "<br>$sql<br>";

    // Run the query
    if (!$mysqli->query($sql)) {
        echo "❌ Insert failed for account [$account]: " . $mysqli->error . "\n";
    } else {
        echo "SUCCESS ✅ F";
    }
}

$mysqli->close();

echo "✅ Finished inserting " . count($results) . " records using mysqli_query().";

    echo "✅ Successfully inserted " . count($results) . " records into `mf_candidates`.";

} catch (PDOException $e) {
    echo "❌ Database error: " . $e->getMessage();
}
fclose($handle);

// Output for debug
echo "<pre>";
// print_r($results);
echo "</pre>";
